<?php
require_once "auth.php"; // <--- ESTO DEBE SER LA LÍNEA 1
require_once 'includes/header.php';
require_once 'includes/sidebar.php';
require_once 'includes/navbar.php';
require_once '../config/db.php';

$marcas = $pdo->query("SELECT * FROM brands ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<main class="flex-1 overflow-y-auto p-6 md:p-8 relative">
    <div class="max-w-5xl mx-auto relative z-10">
        <div class="flex justify-between items-center mb-8">
            <div>
                <h1 class="font-display font-black text-3xl text-gray-900 dark:text-white uppercase">Marcas</h1>
                <p class="text-sm text-gray-500">Fabricantes del arsenal JFD.</p>
            </div>
            <a href="nueva_marca.php" class="bg-brand-red hover:bg-brand-red_hover text-white px-6 py-3 rounded-lg font-bold uppercase tracking-wider shadow-lg transition-all flex items-center gap-2">
                <i class="ri-add-line text-xl"></i> Nueva Marca
            </a>
        </div>

        <div class="mb-4 relative">
            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                <i class="ri-search-line text-gray-400"></i>
            </div>
            <input type="text" id="buscador-marcas" placeholder="Buscar por nombre de marca..." 
                   class="w-full md:w-1/3 pl-10 pr-4 py-2 border border-gray-200 dark:border-white/10 rounded-lg bg-white dark:bg-brand-dark text-gray-900 dark:text-white focus:outline-none focus:border-brand-red dark:focus:border-brand-red transition-colors shadow-sm">
        </div>

        <div class="bg-white dark:bg-brand-dark rounded-xl shadow-sm border border-gray-100 dark:border-white/5 overflow-hidden">
            <table class="w-full text-left text-sm" id="tabla-marcas">
                <thead class="bg-gray-50 dark:bg-white/5 text-xs uppercase font-bold text-gray-500 dark:text-gray-300">
                    <tr>
                        <th class="px-6 py-4">Nombre de la Marca</th>
                        <th class="px-6 py-4">Fecha Registro</th>
                        <th class="px-6 py-4 text-right">Acciones</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100 dark:divide-white/5">
                    <?php foreach($marcas as $m): ?>
                    <tr class="hover:bg-gray-50 dark:hover:bg-white/5 transition-colors fila-marca">
                        <td class="px-6 py-4 font-bold text-gray-900 dark:text-white uppercase tracking-wider">
                            <?php echo $m['name']; ?>
                        </td>
                        <td class="px-6 py-4 text-gray-500">
                            <?php echo date('d/m/Y', strtotime($m['created_at'])); ?>
                        </td>
                        <td class="px-6 py-4 text-right space-x-2">
                            <a href="editar_marca.php?id=<?php echo $m['id']; ?>" class="inline-flex items-center justify-center w-8 h-8 rounded bg-blue-50 text-blue-600 hover:bg-blue-600 hover:text-white transition-all">
                                <i class="ri-pencil-line"></i>
                            </a>
                            <form action="eliminar_marca.php" method="POST" id="form-delete-<?php echo $m['id']; ?>" class="inline-block">
                                <input type="hidden" name="id" value="<?php echo $m['id']; ?>">
                                <button type="button" onclick="confirmDelete(<?php echo $m['id']; ?>, '<?php echo $m['name']; ?>')" 
                                        class="inline-flex items-center justify-center w-8 h-8 rounded bg-red-50 text-red-600 hover:bg-red-600 hover:text-white transition-all">
                                    <i class="ri-delete-bin-line"></i>
                                </button>
                            </form>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
// FUNCIÓN PARA ELIMINAR MARCA (Mantenida intacta)
function confirmDelete(id, name) {
    const isDarkMode = document.documentElement.classList.contains('dark');
    Swal.fire({
        title: '<span class="font-display font-black">¿ELIMINAR MARCA?</span>',
        html: `Borrarás <b>${name}</b>.`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#D90429',
        cancelButtonColor: isDarkMode ? '#262626' : '#9ca3af',
        confirmButtonText: 'SÍ, ELIMINAR',
        cancelButtonText: 'CANCELAR',
        background: isDarkMode ? '#121212' : '#ffffff',
        color: isDarkMode ? '#ffffff' : '#000000'
    }).then((result) => {
        if (result.isConfirmed) { document.getElementById('form-delete-' + id).submit(); }
    });
}

// NUEVA FUNCIÓN PARA EL BUSCADOR DE MARCAS
document.addEventListener('DOMContentLoaded', function() {
    const buscador = document.getElementById('buscador-marcas');
    const filas = document.querySelectorAll('.fila-marca');

    buscador.addEventListener('keyup', function() {
        const textoBusqueda = this.value.toLowerCase();

        filas.forEach(fila => {
            // Extrae el texto de la fila (nombre de la marca)
            const contenidoFila = fila.textContent.toLowerCase();
            
            if (contenidoFila.includes(textoBusqueda)) {
                fila.style.display = ''; // Muestra si hay coincidencia
            } else {
                fila.style.display = 'none'; // Oculta si no coincide
            }
        });
    });
});
</script>
<?php require_once 'includes/footer.php'; ?>